<?php
/**
* @version $Id $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software and parts of it may contain or be derived from the
* GNU General Public License or other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
 */
/**
 * plugin_googlemap2.php,v 2.8 2007/03/24 20:57:06 
 * @copyright (C) Reumer.net
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
 /* ----------------------------------------------------------------
 * 2007-02-10 version 2.7: Improved by Keith Slater and Mike Reumer
 * - artf6173: wheel-mouse zooming
 *   - ??????? Problem with multiple maps
 * - artf7734: Load kml overlay out of file
 *   - New parameter for KML-overlay
 * ---------------------------------------------------------------- */
/* ----------------------------------------------------------------
 * 2007-02-10 version 2.7: Improved by Keith Slater and Mike Reumer
 * - artf7666: Check if javascript is enabled or browser is compatible.
 * - artf7564: Multiple urls
 *   - Added the option to get the single key or search in the multiple url's for a key.
 * - artf6182: Localization
 *   - Get language from the site itself
 *	 - Get language as parameter from the {mosmap}
 *   - Set language if available as parameter or setting
 * ---------------------------------------------------------------- */
/* ----------------------------------------------------------------
 * 2006-12-11 version 2.6: Improved by Eugene Trotsan and Mike Reumer
 * - artf7020: Extra parameter for address.
 *	 - Get the coordinates of the address at google when parameter lon/lat are empty.
 *   - Problem with SimpleXMLElement PHP >= 5
 * - artf6293: Tool tips
 *   - New parameter for tooltip 
 * - artf6995: Turn off overview
 *   - A new value for overview. 2 for overview window to be closed initially.
 * - artf6294 : Turn off infowindow of marker
 *   - New parameter to set infowindow initially closed (0) or open (1 default)
 * - artf6996: Alignment of the map
 *   - New parameter align for the map.
 * ---------------------------------------------------------------- */
/* ----------------------------------------------------------------
 * 2006-10-27 version 2.5: Improved by Mike Reumer
 * - artf6794: Multiple contentitems with maps won't work
 *   - Placed a random text in the name of the googlemap and it's functions.
 * - artf6758: Warning: Wrong value for parameter 4 in call to preg_match_all()
 *   - PREG_OFFSET_CAPTURE has to be combined with PREG_PATTERN_ORDER
 * - artf6755 Call-time pass-by-reference has been deprecated
 *   - Removed & in the call of functions
 * - artf6756 : Warning about variable not defined
 *   - Correctly defined a global parameter
 * ---------------------------------------------------------------- */
/* ----------------------------------------------------------------
 * 2006-10-13 version 2.4: Improved by Mike Reumer
 * - artf6402: Googlemap plugin with tabs not working
 *   - Added a function to look if the offsetposition is changed
 *   - Only make a map when its visible on the page
 *   - Changed event for displaying map in interval for checking if map is visible
 *   - Made important variable in scripts dedicated to the number of the map
 * - artf6456 : Placing defaults of parameters in backoffice
 *   - Created the possibility to set parameters for the plugin in the 
 *     administator of Joomla.
 * - artf6409: Joomla 1.5 support
 *   - Plugin made ready for Joomla 1.5 with configparameter legacy on!
 *   - Calls for Joomla 1.0.x and for Joomla 1.5 created with correct params
 *   - Use a plugin parameter for Joomla 1.5 if plugin is published or not
 * ---------------------------------------------------------------- */
/* ----------------------------------------------------------------
 * 2006-10-02 version 2.3: Improved by Mike Reumer
 * - artf6183: Links not working in Marker
 *   - changed chopping of key and value and translate special htmlcodes
 * - artf6249: Overview initial not the same maptype as map
 *   - changed order of creating controls and setting maptype
 * - artf6280: In IE a big wrong shadow for Marker
 *   - API initialization with wrong version. Removed ".x"
 * ---------------------------------------------------------------- */
/* ----------------------------------------------------------------
 * 2006-09-27 version 2.2: Improved by Mike Reumer
 * - artf6122 Parameters width and height flexible
 *   - Removed px behind width and height
 *   - Changed defaults for width and height parameters
 *   - Check for backward compatibility if units are given
 * - artf6148 Option to turn off the map type selector visibility
 *   - If zoomType is None then no Zoomcontrols (default empty => Small zoomcontrols).
 *   - If showMaptype is 0 then no Maptype controls
 * - artf6176 : Remove mosmap tag if unpublished
 *   - Moved Published within the plugin to remove all the tags
 * - artf6174 : Multiple maps on article w/ {mospagebreak}'s
 *   - Replaced Google maps initialization to the header
 * - Moved default so they are set each {mosmap} 
 * - Settimeout higher for activating to show googlemap (for IE compatibility)
 * - New parameter zoom_new for continues zoom and Doubleclick center and zoom (default 0 => off)
 * - New parameter overview for a overview window at bottom right (default 0 => off)
 * - Scripts made XHTML compliant
 * - artf6150 Documentation with installation
 * ---------------------------------------------------------------- */
/* ----------------------------------------------------------------
 * 2006-09-21: Improved by PILLWAX Industrial Solutions Consulting
 *	- Fixed Script invocation from <body onLoad> to correct JavaScript call
 *   - Add Defaults for parameters
 * ---------------------------------------------------------------- */

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
// Joomla 1.5 defined( '_JEXEC' ) or die( 'Restricted access' );

global $mainframe;

if(method_exists($mainframe,'registerEvent')){
	$mainframe->registerEvent( 'onPrepareContent', 'Pre15x_PluginGoogleMap2' );
}else{
	$_MAMBOTS->registerFunction( 'onPrepareContent', 'Pre10x_PluginGoogleMap2' );
}

/* If PHP < 5 then htmlspecialchars_decode doesn't exists
 */

if ( !function_exists('htmlspecialchars_decode') )
{
	function htmlspecialchars_decode(&$text, $options="")
	{
		return strtr($text, array_flip(get_html_translation_table(HTML_SPECIALCHARS, $options)));
	}
}

/* If PHP < 5 then SimpleXMLElement doesn't exists
 */
function get_geo($address, $key)
{
	if ( !class_exists('SimpleXMLElement') )
	{
		// PHP4
		$uri = "http://maps.google.com/maps/geo?q=".urlencode($address)."&output=xml&key=".$key;
		$getpage = file_get_contents($uri);
		$getpage = utf8_encode($getpage);
		$responsedoc = domxml_open_mem($getpage);
		$response = $responsedoc->get_elements_by_tagname("Response");
		if ($response!=null) {
			$placemark = $response[0]->get_elements_by_tagname("Placemark");
			if ($placemark!=null) {
				$point = $placemark[0]->get_elements_by_tagname("Point");
				if ($point!=null) {
					$coords = $point[0]->get_content();
					return $coords;
				}
			}
		}
		return null;
	}
	else
	{
		// PHP5
		$uri = "http://maps.google.com/maps/geo?q=".urlencode($address)."&output=xml&key=".$key;
		$getpage = file_get_contents($uri);
		$getpage = utf8_encode($getpage);
		$xml = new SimpleXMLElement($getpage);
		$coords = $xml->Response->Placemark->Point->coordinates;
		return $coords;
	}
}
function randomkeys($length)
{
	$key = "";
	$pattern = "1234567890abcdefghijklmnopqrstuvwxyz";
	for($i=0;$i<$length;$i++)
	{
		$key .= $pattern{rand(0,35)};
	}
	return $key;
}

/* Switch call to function of 1.5 to the real module 
 */
function Pre15x_PluginGoogleMap2( &$row, &$params, $page=0 ) {
	global $Itemid, $database;

	// Get Plugin info
	$plugin =& JPluginHelper::getPlugin('content', 'plugin_googlemap2'); 

	$plugin_params = new JParameter( $plugin->params );

	$published = $plugin->published;
	// Solve bug in Joomal 1.5 that when plugin is unpublished that the tag is not removed
	// So use a parameter of plugin to set published for Joomla 1.5
	$published = $plugin_params->get( 'publ', '0' );

	if( !PluginGoogleMap2($published, $row, $params, $page, $plugin_params) ){
		echo "problem";
	}
	return true;
}

/* Switch call to function of 1.0.x to the real module
 */
function Pre10x_PluginGoogleMap2( $published, &$row, $mask=0, $page=0 ) {
	global $database;

	// load plugin parameters
	$query = "SELECT id"
		. "\n FROM #__mambots"
		. "\n WHERE element = 'plugin_googlemap2'"
		. "\n AND folder = 'content'"
		;
	$database->setQuery( $query );
	$id = $database->loadResult();
	$plugin = new mosMambot( $database );
	$plugin->load( $id );
	$plugin_params =& new mosParameters( $plugin->params );

	if( !PluginGoogleMap2($published, $row, $mask, $page, $plugin_params) ){
		echo "problem";
	}
	return true;
}

/** Real module
 */
function PluginGoogleMap2( $published, &$row, $mask=0, $page=0, &$params ) {

	global $mosConfig_absolute_path, $mosConfig_live_site,$mainframe, $mosConfig_locale;

	$id = intval( mosGetParam( $_REQUEST, 'id', null ) );

	$singleregex='/({mosmap\s*)(.*?)(})/i';
	$regex='/{mosmap\s*.*?}/i';

	$cnt=preg_match_all($regex,$row->text,$matches,PREG_OFFSET_CAPTURE | PREG_PATTERN_ORDER);
	$first=true;

	for($counter = 0; $counter < $cnt; $counter ++)
	{
		// Parameters can get the default from the plugin if not empty or from the administrator part of the plugin

		$width = $params->get( 'width', '100%' );
		$height = $params->get( 'height', '400px' );
		$latitude = $params->get( 'lat', '52.075581' );
		$longitude = $params->get( 'lon', '4.541513' );
		$zoom = $params->get( 'zoom', '10' );
		$showmaptype = $params->get( 'showMaptype', '1' );
		$zoom_new = $params->get( 'zoomNew', '0' );
		$zoom_wheel = $params->get( 'zoomWheel', '0' );
		$overview = $params->get( 'overview', '0' );
		$marker = $params->get( 'marker', '1' );
		$gotoaddr = $params->get( 'gotoaddr', '0' );
		$erraddr = $params->get( 'erraddr', 'Address ## not found!' );
		$erraddr = htmlspecialchars_decode($erraddr, ENT_NOQUOTES);
		$txtaddr = $params->get( 'txtaddr', 'Address: <br />##' );
		$txtaddr = htmlspecialchars_decode($txtaddr, ENT_NOQUOTES);
		$txtaddr = str_replace(array("\r\n", "\r", "\n"), '', $txtaddr );
		$align = $params->get( 'align', 'center' );
		$langtype = $params->get( 'langtype', '' );
		
		// Key should be filled in the administrtor part or as parameter with the plugin out of content item
		$key = $params->get( 'Google_API_key', '' );
		if ($key=='')
		{
			$multikey = $params->get( 'Google_Multi_API_key', '' );
                        $replace = array("\n", "\r", "<br/>", "<br />", "<br>");
			$sites = preg_split("/[\n\r]+/", $multikey);

			foreach($sites as $site)
			{
				$values = explode(";",$site, 2);
                                $values[0] = trim(str_replace($replace, '', $values[0]));
                                $values[1] = str_replace($replace, '', $values[1]);
				if (trim($mosConfig_live_site)==$values[0] ||$mosConfig_live_site=="http://".$values[0]) 
				{
					$key = trim($values[1]);
					break;
				}
			}
			
		}

	    // get default lang from $mosConfig_locale
		if ($langtype == 'site') 
		{
	    	$locale_parts = explode('_', $mosConfig_locale);
		    $lang = $locale_parts[0];
		} else if ($langtype == 'config') 
		{
			$lang = $params->get( 'lang', '' );
		} else {
			$lang = '';
		} 

		// Next parameters can be set as default out of the administrtor module or stay empty and the plugin-code decides the default. 
		$zoomType = $params->get( 'zoomType', '' );
		$mapType = $params->get( 'mapType', '' );

		// default empty and should be filled as a parameter with the plugin out of the content item
		$text='';
		$tooltip='';
		$address='';
		$kml='';

		// Give the map a random name so it won't interfere with another map
		$mapnm = randomkeys(5);

		$mosmap=$matches[0][$counter][0];

		if (!$published )
		{
			$row->text = str_replace($mosmap, $code, $row->text);
		} else
		{
			//track if coordinates different from config
			$inline_coords = 0;

			// Match the field details to build the html
			preg_match($singleregex,$mosmap,$mosmapparsed);

			$fields = explode("|", $mosmapparsed[2]);

			foreach($fields as $value)
			{
				$values = explode("=",$value, 2);
				$values=str_replace("'", '', $values);
				$values=str_replace("&#39;",'',$values);

				if($values[0]=='width'){
					$width=$values[1];
				}else if($values[0]=='height'){
					$height=$values[1];
				}else if($values[0]=='lat'){
					$latitude=$values[1];
					$inline_coords = 1;
				}else if($values[0]=='lon'){
					$longitude=$values[1];
					$inline_coords = 1;
				}else if($values[0]=='zoom'){
					$zoom=19-$values[1];
				}else if($values[0]=='key'){
					$key=$values[1];
				}else if($values[0]=='zoomType'){
					$zoomType=$values[1];
				}else if($values[0]=='text'){
					$text=$values[1];
				}else if($values[0]=='tooltip'){
					$tooltip=$values[1];
				}else if($values[0]=='mapType'){
					$mapType=$values[1];
				}else if($values[0]=='showMaptype'){
					$showmaptype=$values[1];
				}else if($values[0]=='zoomNew'){
					$zoom_new=$values[1];
				}else if($values[0]=='zoomWheel'){
					$zoom_wheel=$values[1];
				}else if($values[0]=='overview'){
					$overview=$values[1];
				}else if($values[0]=='marker'){
					$marker=$values[1];
				}else if($values[0]=='address'){
					$address=$values[1];
				}else if($values[0]=='gotoaddr'){
					$gotoaddr=$values[1];
				}else if($values[0]=='align'){
					$align=$values[1];
				}else if($values[0]=='lang'){
					$lang=$values[1];
				}else if($values[0]=='kml'){
					$kml=$values[1];
				}

			}

			if($inline_coords == 0 && !empty($address))
			{
				$coord = get_geo($address, $key);
				list ($longitude, $latitude, $altitude) = explode(",", $coord);
				$inline_coords = 1;
			}

			if (is_numeric($width))
			{
				$width .= "px";
			}
			if (is_numeric($height))
			{
				$height .= "px";
			}

			$code="";

			// Generate the map position prior to any Google Scripts so that these can parse the code
			$code.= "<!-- fail nicely if the browser has no Javascript -->
					<noscript><b>JavaScript must be enabled in order for you to use Google Maps.</b> <br/>
						  However, it seems JavaScript is either disabled or not supported by your browser. <br/>
					      To view Google Maps, enable JavaScript by changing your browser options, and then try again. 
				    </noscript>";
			$code.="<div align=\"".$align."\">";
					
			if ($gotoaddr=='1')
			{
				$code.="<form name=\"gotoaddress".$id."_".$mapnm."_".$counter."\" class=\"gotoaddress\" action=\"javascript:gotoAddress".$id."_".$mapnm."_".$counter."();\">";
				$code.="	<input id=\"txtAddress".$id."_".$mapnm."_".$counter."\" name=\"txtAddress".$id."_".$mapnm."_".$counter."\" type=\"text\" size=\"25\" value=\"\">";
				$code.="	<input name=\"goto\" type=\"button\" class=\"button\" onClick=\"gotoAddress".$id."_".$mapnm."_".$counter."();return false;\" value=\"Goto\">";
				$code.="</form>";
			}

			$code.="<div id=\"googlemap".$id."_".$mapnm."_".$counter."\" style=\"width:".$width."; height:".$height."\"></div>";
			$code.="</div>";

			// Only add the google javascript once
			if($first)
			{
				if ($lang!='')
					$mainframe->addCustomHeadTag( "<script src=\"http://maps.google.com/maps?file=api&amp;v=2.x&amp;hl=".$lang."&amp;key=".$key."\" type=\"text/javascript\"></script>");
				else
					$mainframe->addCustomHeadTag( "<script src=\"http://maps.google.com/maps?file=api&amp;v=2.x&amp;key=".$key."\" type=\"text/javascript\"></script>");

				$first=false;
			}

			$code.="<script type='text/javascript'>//<![CDATA[\n";

			// Globale map variable linked to the div
			$code.="var tst".$id."_".$mapnm."_".$counter."=document.getElementById('googlemap".$id."_".$mapnm."_".$counter."');
			var tstint".$id."_".$mapnm."_".$counter.";
			var map".$id."_".$mapnm."_".$counter.";
			";

			if($zoom_wheel=='1')
			{
				$code.="function CancelEvent".$id."_".$mapnm."_".$counter."(event) { 
					        var e = event; 
					        if (typeof e.preventDefault == 'function') e.preventDefault(); 
						        if (typeof e.stopPropagation == 'function') e.stopPropagation(); 
	
					        if (window.event) { 
				                window.event.cancelBubble = true; // for IE 
				                window.event.returnValue = false; // for IE 
					        } 
						}
					";
			}

			if ($gotoaddr=='1')
			{
				$code.="function gotoAddress".$id."_".$mapnm."_".$counter."() {
							var address = document.getElementById('txtAddress".$id."_".$mapnm."_".$counter."').value;

							if (address.length > 0) {
							    var geocoder = new GClientGeocoder();

							    geocoder.getLatLng(address,
							    function(point) {
							        if (!point) {
										var erraddr = '{$erraddr}';
										erraddr = erraddr.replace(/##/, address);
							          alert(erraddr);
							        } else {
									  var txtaddr = '{$txtaddr}';
									  txtaddr = txtaddr.replace(/##/, address);
							          map".$id."_".$mapnm."_".$counter.".setCenter(point);
									  map".$id."_".$mapnm."_".$counter.".openInfoWindowHtml(point,txtaddr);
									  setTimeout('map".$id."_".$mapnm."_".$counter.".closeInfoWindow();', 5000);
							        }
							      });
							  }
						}";
			}

			// Functions to wacth if the map has changed
			$code.="function checkMap".$id."_".$mapnm."_".$counter."()
			{
				if (tst".$id."_".$mapnm."_".$counter.")
					if (tst".$id."_".$mapnm."_".$counter.".offsetWidth != tst".$id."_".$mapnm."_".$counter.".getAttribute(\"oldValue\"))
					{
						tst".$id."_".$mapnm."_".$counter.".setAttribute(\"oldValue\",tst".$id."_".$mapnm."_".$counter.".offsetWidth);

						if (tst".$id."_".$mapnm."_".$counter.".getAttribute(\"refreshMap\")==0)
							if (tst".$id."_".$mapnm."_".$counter.".offsetWidth > 0) {
								clearInterval(tstint".$id."_".$mapnm."_".$counter.");
								getMap".$id."_".$mapnm."_".$counter."();
								tst".$id."_".$mapnm."_".$counter.".setAttribute(\"refreshMap\", 1);
							} 
					}
			}
			";

			// Function for displaying the map and marker
			$code.="	function getMap".$id."_".$mapnm."_".$counter."(){
				if (tst".$id."_".$mapnm."_".$counter.".offsetWidth > 0) {
					map".$id."_".$mapnm."_".$counter." = new GMap2(document.getElementById('googlemap".$id."_".$mapnm."_".$counter."'));
					";

					if($zoomType!='None')
					{
						if($zoomType=='Large')
						{
							$code.="map".$id."_".$mapnm."_".$counter.".addControl(new GLargeMapControl());";
						} else
						{
							$code.="map".$id."_".$mapnm."_".$counter.".addControl(new GSmallMapControl());";
						}
					} 

					if(!$overview==0)
					{
						$code.="var overviewmap = new GOverviewMapControl();";
						$code.="map".$id."_".$mapnm."_".$counter.".addControl(overviewmap, new GControlPosition(G_ANCHOR_BOTTOM_RIGHT));";
						
						if($overview==2)
						{
							$code.="overviewmap.hide(true);";
						}
					}

					if($showmaptype!='0')
					{
						$code.="map".$id."_".$mapnm."_".$counter.".addControl(new GMapTypeControl());";
					} 

					$code.="map".$id."_".$mapnm."_".$counter.".setCenter(new GLatLng(".$latitude.", ".$longitude."), ".$zoom.");";

					if($mapType=='Satellite')
					{
						$code.="map".$id."_".$mapnm."_".$counter.".setMapType(G_SATELLITE_MAP);";
					} else
					{
						if($mapType=='Hybrid')
						{
							$code.="map".$id."_".$mapnm."_".$counter.".setMapType(G_HYBRID_MAP);";
						} else
						{
							$code.="map".$id."_".$mapnm."_".$counter.".setMapType(G_NORMAL_MAP);";
						}
					}

					if($zoom_new=='1')
					{
						$code.="map".$id."_".$mapnm."_".$counter.".enableContinuousZoom();
						map".$id."_".$mapnm."_".$counter.".enableDoubleClickZoom();
						";
					} 

					if($zoom_wheel=='1')
					{
						$code.="map".$id."_".$mapnm."_".$counter.".enableScrollWheelZoom();
						";
					} 


					if (($inline_coords == 1)||($inline_coords == 0 && empty($kml))) {

						$code.="var point = new GPoint( $longitude, $latitude);";

						if (trim($tooltip)!='') 
							$code.="var marker".$id."_".$mapnm."_".$counter." = new GMarker(point, {title:\"".$tooltip."\"});";
						else
							$code.="var marker".$id."_".$mapnm."_".$counter." = new GMarker(point);";
						
						$code.="map".$id."_".$mapnm."_".$counter.".addOverlay(marker".$id."_".$mapnm."_".$counter.");
						";

						if(trim($text)!='')
						{
							$text = htmlspecialchars_decode($text, ENT_NOQUOTES);
							// If marker 
						
							if ($marker==1)
								$code.="marker".$id."_".$mapnm."_".$counter.".openInfoWindowHtml(\"".$text."\");";
							
							$code.="GEvent.addListener(marker".$id."_".$mapnm."_".$counter.", 'click', function() {
									marker".$id."_".$mapnm."_".$counter.".openInfoWindowHtml(\"".$text."\");
									});
							";
						}
					}
					
					if($zoom_wheel=='1')
					{
						$code.="GEvent.addDomListener(tst".$id."_".$mapnm."_".$counter.", 'DOMMouseScroll', CancelEvent".$id."_".$mapnm."_".$counter.");
								GEvent.addDomListener(tst".$id."_".$mapnm."_".$counter.", 'mousewheel', CancelEvent".$id."_".$mapnm."_".$counter.");
							";
					}
					
					if ($kml!='') {
						$code .= "var xml = new GGeoXml(\"".$kml."\");";
						$code .= "map".$id."_".$mapnm."_".$counter.".addOverlay(xml);";
					}

					// End of script voor showing the map 
					$code.="}
		}
		//]]></script>
		";

		// Call the Maps through timeout to render in IE also
		// Set an event for watching the changing of the map so it can refresh itself
		$code.= "<script type=\"text/javascript\">//<![CDATA[
			    if (GBrowserIsCompatible()) {
					tst".$id."_".$mapnm."_".$counter.".setAttribute(\"oldValue\",0);
					tst".$id."_".$mapnm."_".$counter.".setAttribute(\"refreshMap\",0);
					tstint".$id."_".$mapnm."_".$counter."=setInterval(\"checkMap".$id."_".$mapnm."_".$counter."()\",500);
				}
		//]]></script>
		";

		$row->text = str_replace($mosmap, $code, $row->text);
		} 

	}

	return true;
}

?>
